#include "h/uart.h"

void sendUART(BYTE x)
{
	int i;
	while(U1STAbits.UTXBF);	
	U1TXREG=x;
	for(i=0; i<100; i++);	
}

void initUART(void)
{
	RPINR18=0x1F06;			// UART 1 Rx pin to RP6 
	RPOR3=0x0300;			// UART 1 Tx pin to RP7
	U1BRG=21;
	U1MODE=0;
	U1MODEbits.UARTEN=1;	// enable the module
	U1STAbits.UTXINV=1;
	U1STAbits.UTXEN=1;		// enable Tx- this must be *after* the module has been enabled!
}

void disAUART(BYTE x)
{
	sendUART(disFix(x>>4));
	sendUART(disFix(x));
}

void disIntUART(unsigned int x)
{
	sendUART(disFix(0x0F & (x>>12)));
	sendUART(disFix(0x0F & (x>>8)));
	sendUART(disFix(0x0F & (x>>4)));
	sendUART(disFix(0x0F & x));
}

void sendStringUART(BYTE* inptr)
{
	while(*inptr)
	{
		sendUART(*inptr++);
	}

}


